#!/bin/bash
oxDNAdir=/path/to/oxDNA
python2dir=/path/to/python2
python3dir=/path/to/python3
scriptDir=/path/to/backend
export PATH=/usr/local/lib/vmd:/home/muratalab/install/cogli1/build/bin:$PATH

#tentative cadnano file
cadnano=$1
#directory of simulation
dir=$2
#lattice is sq or he
lattice=$3
#temperature is in Celcius
temperature=$4
#sodium concentration in M
na=$5
#total step
steps=$6
#interval step
interval=$7
cd $dir
#echo "input directory is " $dir >> out.txt
#echo "lattice type is "$lattice >> out.txt

echo "----------Start to copy files----------" >> out.txt
xvfb-run -a ${pythondir}/python ${scriptDir}/CadnanoOperation.py ${cadnano} ${dir} 1>/dev/null 2>/dev/null #open and save cadnano file
if [ ! -e cadnano.json ]; then
 echo 'Cannot open and copy to cadnano.json, please select correct cadnano file.' >> out.txt
 exit 1
fi
cp ${scriptDir}/input_relax .
echo steps = ${steps} >> input_relax
echo print_conf_interval = ${interval} >> input_relax
echo print_energy_every = ${interval} >> input_relax
echo T=${temperature}C >> input_relax
echo salt_concentration=${na} >> input_relax
cp ${scriptDir}/cameraX.cpy .
cp ${scriptDir}/cameraY.cpy .
cp ${scriptDir}/cameraZ.cpy .
cp ${scriptDir}/cameraXYZ.cpy .
rm -r $(dirname ${cadnano})
echo "----------Copied----------" >> out.txt

echo "----------Start to make initial configuration----------" >> out.txt
export INKSCAPE_PROFILE_DIR=$(pwd)
xvfb-run -a inkscape -z -f slice.svg --vacuum-defs -D -l slice.svg
xvfb-run -a inkscape -z -f slice.svg --vacuum-defs -D -A slice.pdf
xvfb-run -a inkscape -z -f slice.svg -d 2000 -e slice.png
xvfb-run -a inkscape -z -f path.svg --vacuum-defs -D -l path.svg
xvfb-run -a inkscape -z -f path.svg --vacuum-defs -D -A path.pdf
xvfb-run -a inkscape -z -f path.svg -d 500 -e path.png
${python2dir}/python ${oxDNAdir}/UTILS/cadnano_interface.py cadnano.json $lattice  1>/dev/null 2>/dev/null
if [ ! -e prova.top ]; then
 echo 'Cannot find top.top (or prova.top), do not use broken cadnano file. Skip and/or insert may also cause this problem.' >> out.txt
 exit 1
elif [ ! -e prova.conf ]; then
 echo 'Cannot find initial.conf (or prova.conf), do not use broken cadnano file. Skip and/or insert may also cause this problem.' >> out.txt
 exit 1
fi
mv prova.top top.top
mv prova.conf initial.conf
${python2dir}/python ${oxDNAdir}/UTILS/traj2vis.py xyz initial.conf top.top 1>/dev/null 2>/dev/null
echo "----------Made----------" >> out.txt

usage0=$(nvidia-smi | sed -n 12p | cut -c 61-63)
usage1=$(nvidia-smi | sed -n 9p | cut -c 61-63)
if [ $usage0 -ge 5 ] && [ $usage1 -ge 5 ] ; then
 echo "gpu is busy now, the simulation is cancelled." >> out.txt
else
 cuda=0
 if [ $usage0 -ge 5 ] ; then
  cuda=1
 fi
 echo CUDA_device = ${cuda} >> input_relax #GPU number added to the input_relax

echo "----------Start to relax----------" >> out.txt
cp initial.conf trajectory_relax.conf
oxDNA input_relax 1>>out.txt 2>>error.txt
mv last_conf.dat last_conf_relax.conf
echo 'Converting conf to xyz format' >> out.txt
${python2dir}/python ${oxDNAdir}/UTILS/traj2vis.py xyz last_conf_relax.conf top.top 1>/dev/null 2>/dev/null
if [ ! -e energy_relax.txt ]; then
 echo 'Cannot find energy_relax.txt, something went wrong during the simulation.' >> out.txt
 exit 1
elif [ ! -e trajectory_relax.conf ]; then
 echo 'Cannot find trajectory_relax.conf, something went wrong during the simulation.' >> out.txt
 exit 1
fi
echo "----------Relaxed----------" >> out.txt

echo "----------Start to compute RMSD and plot graphs----------" >> out.txt
${python2dir}/python ${oxDNAdir}/UTILS/traj2vis.py xyz trajectory_relax.conf top.top 1>/dev/null 2>/dev/null
vmd -dispdev text -xyz trajectory_relax.conf.xyz -eofexit < ${scriptDir}/analysis.vmd 1>/dev/null 2>/dev/null
paste energy_relax.txt rmsd.txt > rmsd_plot.txt
gnuplot -persist ${scriptDir}/analysis.plot 1>>out.txt 2>>error.txt
files=("energy_all_oxDNA" "energy_oxDNA" "energy_all" "energy" "rmsd_oxDNA" "rmsd")
for file in "${files[@]}"
do
 xvfb-run -a inkscape -z -f ${file}.svg --vacuum-defs -l ${file}.svg
 xvfb-run -a inkscape -z -f ${file}.svg --vacuum-defs -A ${file}.pdf
 xvfb-run -a inkscape -z -f ${file}.svg -d 100 -e ${file}.png
done
rm rmsd_plot.txt
echo "----------Computed and ploted----------" >> out.txt

echo "----------Start to visualize by VMD----------" >>out.txt
vmd -dispdev text -xyz trajectory_relax.conf.xyz -eofexit < ${scriptDir}/xyz2visualize.vmd 1>/dev/null 2>/dev/null
echo "Converting ppm to transparent png" >>out.txt
for file in $(find . -maxdepth 1 -type f -name "*.ppm"); do
 convert -alpha set -transparent white ${file} ${file%.*}.png
done
rm *.ppm
echo "Converting png to animation gif" >> out.txt
rename 's/_(\d{1})_/_00$1_/' *_vmd.png
rename 's/_(\d{2})_/_0$1_/' *_vmd.png
convert -delay 10 -loop 0 -dispose 2 -layers optimize x_*_vmd.png x_animate_vmd.gif
convert -delay 10 -loop 0 -dispose 2 -layers optimize y_*_vmd.png y_animate_vmd.gif
convert -delay 10 -loop 0 -dispose 2 -layers optimize z_*_vmd.png z_animate_vmd.gif
convert -delay 10 -loop 0 -dispose 2 -layers optimize xyz_*_vmd.png xyz_animate_vmd.gif
echo "----------Visualized----------" >> out.txt

echo "----------Start to visualize by cogli1----------" >> out.txt
boxsize=$(cat size.txt)
echo "look_at $(($boxsize / 2)) $(($boxsize / 2)) $(($boxsize / 2))" >> cameraX.cpy
echo "look_at $(($boxsize / 2)) $(($boxsize / 2)) $(($boxsize / 2))" >> cameraY.cpy
echo "look_at $(($boxsize / 2)) $(($boxsize / 2)) $(($boxsize / 2))" >> cameraZ.cpy
echo "look_at $(($boxsize / 2)) $(($boxsize / 2)) $(($boxsize / 2))" >> cameraXYZ.cpy
echo "position $boxsize $(($boxsize / 2)) $(($boxsize / 2))" >> cameraX.cpy
echo "position $(($boxsize / 2)) $boxsize $(($boxsize / 2))" >> cameraY.cpy
echo "position $(($boxsize / 2)) $(($boxsize / 2)) $boxsize" >> cameraZ.cpy
echo "position $(($boxsize * 789 / 1000)) $(($boxsize * 789 / 1000)) $(($boxsize * 789 / 1000))" >> cameraXYZ.cpy
cogli1 --always-centre -v --mm-grooving --bcab --colors-from=color.txt --box=$boxsize,$boxsize,$boxsize --only-pov --load cameraX.cpy --topology top.top trajectory_relax.conf 1>/dev/null 2>/dev/null
rename s/trajectory_relax.conf_/x_/ *.pov
rename s/_time.*/_cogli1.pov/g *.pov
for d in $(ls -v1 *.pov); do povray -D +H800 +W800 $d 1>/dev/null 2>/dev/null; done
rm *.pov
cogli1 --always-centre -v --mm-grooving --bcab --colors-from=color.txt --box=$boxsize,$boxsize,$boxsize --only-pov --load cameraY.cpy --topology top.top trajectory_relax.conf 1>/dev/null 2>/dev/null
rename s/trajectory_relax.conf_/y_/ *.pov
rename s/_time.*/_cogli1.pov/g *.pov
for d in $(ls -v1 *.pov); do povray -D +H800 +W800 $d 1>/dev/null 2>/dev/null; done
rm *.pov
cogli1 --always-centre -v --mm-grooving --bcab --colors-from=color.txt --box=$boxsize,$boxsize,$boxsize --only-pov --load cameraZ.cpy --topology top.top trajectory_relax.conf 1>/dev/null 2>/dev/null
rename s/trajectory_relax.conf_/z_/ *.pov
rename s/_time.*/_cogli1.pov/g *.pov
for d in $(ls -v1 *.pov); do povray -D +H800 +W800 $d 1>/dev/null 2>/dev/null; done
rm *.pov
cogli1 --always-centre -v --mm-grooving --bcab --colors-from=color.txt --box=$boxsize,$boxsize,$boxsize --only-pov --load cameraXYZ.cpy --topology top.top trajectory_relax.conf 1>/dev/null 2>/dev/null
rename s/trajectory_relax.conf_/xyz_/ *.pov
rename s/_time.*/_cogli1.pov/g *.pov
for d in $(ls -v1 *.pov); do povray -D +H800 +W800 $d 1>/dev/null 2>/dev/null; done
rm *.pov
echo "Converting png to transparent png" >> out.txt
for file in $(find . -maxdepth 1 -type f -name "*_cogli1.png"); do
 convert -alpha set -transparent white ${file} ${file}
done
echo "Converting png to animation gif" >> out.txt
rename 's/_(\d{1})_/_00$1_/' *_cogli1.png
rename 's/_(\d{2})_/_0$1_/' *_cogli1.png
convert -delay 10 -loop 0 -dispose 2 -layers optimize x_*_cogli1.png x_animate_cogli1.gif
convert -delay 10 -loop 0 -dispose 2 -layers optimize y_*_cogli1.png y_animate_cogli1.gif
convert -delay 10 -loop 0 -dispose 2 -layers optimize z_*_cogli1.png z_animate_cogli1.gif
convert -delay 10 -loop 0 -dispose 2 -layers optimize xyz_*_cogli1.png xyz_animate_cogli1.gif
echo "----------Visualized----------" >> out.txt

echo "----------Start to compress----------" >> out.txt
zip result.zip *.gif *.png *.svg *.pdf *.txt *.cpy *.json *.csv *.top *.xyz *.conf input_relax  1>/dev/null 2>/dev/null
echo "----------Compressed----------" >> out.txt

fi
