#!/bin/bash
backendDir=/path/to/backend

#echo "----------Start to prepare----------"
#directory to make a new directory
dataDir=$1
#name of the cadnano file without space nor 2byte letters
cadnano=$2
#lattice is sq or he
lattice=$3
#temperature is in Celcius
temperature=$4
#sodium concentration in M
na=$5
#total step
steps=$6
#interval step
interval=$7
#echo "directory is "$dataDir
#echo "input is "$cadnano
#echo "lattice type is "$lattice
#echo "temperature is "$temperature
#echo "na concentration is "$na
#echo "total step is "$steps
#echo "interval step is "$interval
usage0=$(nvidia-smi | sed -n 12p | cut -c 61-63)
usage1=$(nvidia-smi | sed -n 9p | cut -c 61-63)
if [ $usage0 -ge 5 ] && [ $usage1 -ge 5 ] ; then
 echo gpu_busy
else
 date=$(date '+%Y%m%d%H%M%S')
 #echo "directory is "$date
 mkdir ${dataDir}/${date}

 bash ${backendDir}/cadnano2oxDNA.sh ${cadnano} ${dataDir}/${date} $lattice $temperature $na $steps $interval & #Run simulation in background
 fileOnly=${cadnano##*/}
 echo '<a href="/oxDNA/result.html?target='${date}'">' ${date} : ${fileOnly%.*} '</a><br>' >> ${dataDir}/target.html
 echo $date #return the target date
fi
