set style line 1 pointtype 7 pointsize 0.5 linewidth 2 linecolor rgb "light-red"
set style line 2 pointtype 13 pointsize 0.5 linewidth 2 linecolor rgb "web-green"
set style line 3 pointtype 9 pointsize 0.5 linewidth 2 linecolor rgb "web-blue"
set style line 4 pointtype 7 pointsize 0.5 linewidth 2 linecolor rgb "black"
set output "energy_all_oxDNA.svg"
set key outside
set xlabel "time (x1000 oxDNA unit)"
set ylabel "energy (oxDNA unit)"
set terminal svg font "Arial-Bold,16"
plot "energy_relax.txt" u ($1/1000):4 t "total" linestyle 1, "energy_relax.txt" u ($1/1000):2 t "potential" linestyle 2,  "energy_relax.txt" u ($1/1000):3 t "kinetic" linestyle 3
set output
set output "energy_oxDNA.svg"
plot "energy_relax.txt" every ::1 u ($1/1000):4 notitle linestyle 4
set output

set xlabel "time (ns)"
set ylabel "energy (kcal/mole)"
set output "energy_all.svg"
plot "energy_relax.txt" u ($1*3.03*1e-3):($4*4.142*0.000239*6.022*1e3) t "total" linestyle 1, "energy_relax.txt" u ($1*3.03*1e-3):($2*4.142*0.000239*6.022*1e3) t "potential" linestyle 2,  "energy_relax.txt" u ($1*3.03*1e-3):($3*4.142*0.000239*6.022*1e3) t "kinetic" linestyle 3
set output
set output "energy.svg"
plot "energy_relax.txt" every ::1  u ($1*3.03*1e-3):($4*4.142*0.000239*6.022*1e3) notitle linestyle 4
set output

set xlabel "step (frame)"
set ylabel "rmsd (oxDNA unit)"
set output "rmsd_oxDNA.svg"
plot "rmsd.txt" u 1:2 notitle linestyle 4
set output

set xlabel "time (ns)"
set ylabel "rmsd (nm)"
set output "rmsd.svg"
plot "rmsd_plot.txt" u ($1*3.03*1e-3):($6*8.518*1e-1) notitle linestyle 4
set output
