import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Random;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;

@WebServlet("/OXDNAConverter") @MultipartConfig(maxFileSize=10485760) public class OXDNAConverter extends HttpServlet{
 private static final long serialVersionUID=1L;
 public OXDNAConverter(){}
 private String getRandomString(){
  Random random=new Random(System.currentTimeMillis());
  StringBuffer answer=new StringBuffer();
  for(int index=0;index<10;index++){
   int next=random.nextInt(36);
   if(next<10) answer.append(next);
   else answer.append((char)('a'+next-10));
  }
  return answer.toString();
 }
 protected void doPost(HttpServletRequest request,HttpServletResponse response) throws ServletException,IOException{
  ServletContext context=this.getServletContext();
  Part partCadnano=request.getPart("cadnanoFile");
  String nameFile=partCadnano.getSubmittedFileName();
  if(!nameFile.endsWith(".cadnano")&&!nameFile.endsWith(".json")) return;
  nameFile=nameFile.replaceAll(".cadnano$","").replaceAll(".json$","").replaceAll("[ %<>:;'\\(\\)\\t\\n\\r\\.\\*\\?\\\"\\|\\$\\\\]","");
  if(nameFile.length()>80) nameFile=nameFile.substring(0,80);
  File workdir=(File)context.getAttribute("javax.servlet.context.tempdir");
  String nameDirectory=getRandomString();
  File directory=new File(workdir.getAbsolutePath()+File.separator+nameDirectory+File.separator);
  directory.mkdir();
  String path=directory.getAbsolutePath();
  String cadnanopath=path+File.separator+nameFile+".json";
  partCadnano.write(cadnanopath);

 String temperature=request.getParameter("pmt_temp").replaceAll("[%<>:;'\\(\\)\\t\\n\\r\\.\\*\\?\\\"\\|\\$\\\\]","");
     
 String salt=request.getParameter("pmt_con").replaceAll("[ %<>:;'\\(\\)\\t\\n\\r\\*\\?\\\"\\|\\$\\\\]","");

 String lattice=request.getParameter("pmt_lattice").replaceAll("[ %<>:;'\\(\\)\\t\\n\\r\\.\\*\\?\\\"\\|\\$\\\\]","");

 String step=request.getParameter("pmt_step").replaceAll("[ %<>:;'\\(\\)\\t\\n\\r\\.\\*\\?\\\"\\|\\$\\\\]","");

 int stepType=Integer.parseInt(step);
 String total="";
 String interval="";
 switch(stepType){
  case 1:
   total="3e5";
   interval="3e3";
   break;
  case 2:
   total="3e6";
   interval="3e4";
   break;
  case 3:
   total="3e7";
   interval="3e5";
   break;
 }

 try{
      ProcessBuilder processBuilder=new ProcessBuilder("bash","/path/to/backend/bridge.sh",request.getServletContext().getRealPath("/")+"data", cadnanopath ,lattice, temperature, salt, total, interval);
      
   Process process=processBuilder.start();
   process.waitFor();
   BufferedReader standardOutput=new BufferedReader(new InputStreamReader(process.getInputStream()));
   String processed=standardOutput.readLine();
   //(new File(cadnanopath)).delete();
   //if(!sequencepath.equalsIgnoreCase("none")) (new File(sequencepath)).delete();
   //directory.delete();
   response.sendRedirect("result.html?target="+processed);
  }catch(Exception e){
   e.printStackTrace();
  }
 }
}
